/*
 * Various utility functions
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "types.h"

#ifndef _UTILS_H_
#define _UTILS_H_

#include <stdio.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

const char * Util_Separate(const char **, char);
void Util_SepTo(char *, int, const char **, char);
void Util_Explode(const char *, char, const char **, int);
int Util_Count(const char *, char);
TF Util_Isalnum(const char *);
void Util_Copy(char *, const char *, unsigned int size);
void Util_Cat(char *, const char *, unsigned int size);
void Util_Strip(char *, unsigned int size, TF flag);
void Util_Eputs(const char *);
void Util_Eprintf(const char *, ...);
char * Util_FormatA(const char *, ...);
const char * Util_Format(const char *, ...);
const char * Util_FormatD(const char *, const char *, const char *,
			  const char *);
const char * Util_CTCPFmt(const char *, const char *);
const char * Util_CTCPFmtD(const char *, const char *);
char Util_hex2dec(char);
char Util_dec2hex(char);

#ifdef __cplusplus
}
#endif

#endif

/* @(#) $Id$ */
