/*
 * Lachesis, an IRCRPG combat engine
 * Copyright 2002 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "alloc.h"
#include "types.h"

#ifndef _LACHESIS_H_
#define _LACHESIS_H_

typedef struct tag_cmd_opts {
  char channel[ALLOC_CHAN];
  char key[ALLOC_BUFFER];
  char userinfo[ALLOC_BUFFER];
  char ircnick[ALLOC_NICK];
  char ircname[ALLOC_NAME];
  char ircuser[ALLOC_USER];
  char server[ALLOC_HOST];
  uint16 port;
  char quitmessage[ALLOC_BUFFER];
  char *datadir;
  char *logfile;
  char logtitle[ALLOC_BUFFER];
  TF logooc;
  TF nodesccmt;
  TF logother;
  TF pubdice;
  FILE *errlog;
} CmdOpts;

#ifdef __cplusplus
extern "C" {
#endif

void Shutdown();

// from version.c
const char * Lachesis_Version();
const char * Lachesis_CYear();

#ifdef __cplusplus
}
#endif

#endif

/* @(#) $Id$ */
