/*
 * Lachesis high-level IRC Interface API
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _IRC_H_
#define _IRC_H_

#ifndef _IN_LOWLEVEL_INTERFACE
#include "irccl.h"

#define UHFLAG_OPER 1
#define UHFLAG_AWAY 2

void HLIRC_AddChan(const char *);
void HLIRC_RemChan(const char *);
TF   HLIRC_CheckChan(const char *);
void HLIRC_CleanChan();
void HLIRC_BeginIRCInterface();
void HLIRC_EndIRCInterface();
void HLIRC_Cleanup();
#else

// Functions we provide to the direct interface to contact us

#ifdef __cplusplus
extern "C" {
#endif

void ConnectionReady();

void HandleDCCChatRequest(void *, const char *nick);
void HandleDCCChatRequestPfx(void *, const char *prefix);
void HandleDCCChatOpened(void *);
void HandleDCCChatClosed(void *);
void HandleDCCChatMessage(void *, const char *);
void HandleNumeric(const int, const char *);
void HandleNotice(const char *prefix, const char *target, const char *);
const char * HandleCTCP(const char *prefix, const char *target, const char *);
void HandleCTCPReply(const char *prefix, const char *);
void HandleNames(const char *channel, const char **, const int);
void HandleName(const char *channel, const char *);
void HandleInvite(const char *prefix, const char *);
void HandleKick(const char *nick, const char *target, const char *channel, const char *);
void HandleMSG(const char *prefix, const char *);
void HandlePublic(const char *prefix, const char *target, const char *);
void HandleJoined(const char *channel);
void HandleJoin(const char *prefix, const char *channel);
void HandleOurNickChanged(const char *nick);
void HandleNickChange(const char *prefix, const char *nick);
void HandlePart(const char *nick, const char *channel, const char *);
void HandleQuit(const char *nick, const char *);
void HandleDisconnect(const char *, TF flag);
void HandleUserhost(const char *nick, const char *user, const char *host);

#ifdef __cplusplus
}
#endif

#endif /* _IN_LOWLEVEL_INTERFACE */

#endif /* _IRC_H_ */

/* @(#) $Id$ */
