/*
 * Lachesis, an IRCRPG combat engine - Random number generation
 * Copyright 2003-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Since the random elements of the formulas are stated as dice rolls,
 * the random number generation will operate on that basis.
 */

#include <string.h>
//#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "random.h"
#include "../utils.h"
#include "../config.h"
#include "../types.h"

static char* id="@(#) $Id$";

TF Random_Roll(unsigned long count, unsigned long magnitude, long floor,
	       long **rolls)
{
  unsigned long excess, loop;

  if (rolls==NULL)
    return FALSE;
  if (count==0||count>DICE_MAX)
    return FALSE;
  if (magnitude<2)
    return FALSE;
  *rolls = new long[count+1];
  **rolls = 0;
  for (loop=0;loop<count;loop++) {
    excess = RAND_MAX / magnitude;
    if (excess==0) {
      delete [] *rolls;
      return FALSE;
    }
    do
      (*rolls)[loop+1] = rand() / excess;
    while ((*rolls)[loop+1]>=magnitude);
    if (floor<0) {
      unsigned long sub = (unsigned long)(-1*floor);
      if (sub>(*rolls)[loop+1])
	(*rolls)[loop+1] = sub - (*rolls)[loop+1];
      else
	(*rolls)[loop+1] -= sub;
    } else
      (*rolls)[loop+1] += (unsigned long)(floor);
    (*rolls)[0] += (*rolls)[loop+1];
  }
  return TRUE;
}

TF Random_WRoll(unsigned long count, unsigned long threshold, long **rolls)
{
  // This roller has been added for Storm, and meets the roll requirements
  // for Werewolf.
  // Quick fix: there seems to be two different versions of botching; the
  // ST's book goes by adjusted success total being negative, everyone
  // else's says it's 0 successes and 1 or more botch. I don't know which
  // is the more recent rule, but now both are supported based on
  // WROLL_USES_SUCC_FLAG

  unsigned long excess, loop;
#ifdef WROLL_USES_SUCC_FLAG
  TF success = FALSE;
#endif

  if (rolls==NULL)
    return FALSE;
  if (count==0||count>DICE_MAX)
    return FALSE;
  if (threshold<2||threshold>10)
    return FALSE;
  *rolls = new long[count+1];
  **rolls = 0;
  for (loop=0;loop<count;loop++) {
    excess = RAND_MAX / 10;
    do
      (*rolls)[loop+1] = rand() / excess + 1;
    while ((*rolls)[loop+1]>10);

    if ((*rolls)[loop+1]==1)
      (**rolls)--;
    else if ((*rolls)[loop+1]>=threshold) {
      (**rolls)++;
#ifdef WROLL_USES_SUCC_FLAG
      success = TRUE;
#endif
    }
  }
#ifdef WROLL_USES_SUCC_FLAG
  if (success&&(**rolls)<0)
    (**rolls)=0;
#endif
  return TRUE;
}
