/*
 * Lachesis IRCRPG Combat Engine - Configuration options
 * Copyright 2003-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

/*
 * Define this to enable debugging messages from Lachesis (very spammy)
 * Every time I have trouble tracing where a problem occured, I add some
 * messages of this type. Reading the debugging messages is a good way to
 * get a feel of how the system fits together, since most of the major calls
 * produce a notice that they were called.
 */
#define DEBUG

/*
 * Define this to the name of a file where stderr messages will be logged.
 * Saves a bit of hassle trying to redirect this constantly.
 */
#define STDERR_LOG_FILE "error.log"

/*
 * Defining this will disable checking the userid of the process for
 * registering on IRC. If no username is specified at the command line,
 * DFL_IRCUSER will be used.
 */
#undef NO_USERID

/*
 * These set the default information for use in registering to IRC. They
 * can be overridden at the command line. Note that unless NO_USERID is
 * defined, DFL_IRCUSER has no effect.
 */
#ifndef RPGSERV
#define DFL_IRCNICK "Lachesis"
#define DFL_IRCNAME "Measuring the threads of Fate"
#define DFL_IRCUSER "lachesis"
#else
#define DFL_IRCNICK "RPGServ"
#define DFL_IRCNAME "RPG Character or Extra"
#define DFL_IRCUSER "rpgserv"
#endif

/*
 * This is the default channel to connect to upon start, and can be
 * overridden at the command line. Note that if this is not defined, and
 * no channel is specified at the command line, Lachesis will not join a
 * channel; if the master account has the security option set, IT WILL
 * BE IMPOSSIBLE TO LOG IN, thus making the bot unusable. You should
 * probably have this set to something.
 */
#define DFL_IRCCHAN "#dragoon's-birth"

/*
 * If this is defined, then Lachesis will try to reconnect to the server
 * instead of cleaning up and exiting when disconnected. I don't think this
 * is fully implemented yet. Use at your own risk.
 */
#undef AUTO_RECONNECT

/*
 * RPGServ only: Defining this will restrict RPGServ's MSG and NOTICE commands
 * to the master account. By default, any authorized user can use MSG and
 * NOTICE. This has no effect on Lachesis; only the master account can use
 * the actions module in Lachesis.
 */
#undef NO_USER_MSGNOTICE

/*
 * RPGServ only: Defining this will cause RPGServ to honor the ROLL and
 * WROLL commands regardless of whether the requester is a recognized user.
 */
#define ALLOW_ANY_TO_ROLL

/*
 * Affects WROLL behavior. See engine/random.cc
 */
#define WROLL_USES_SUCC_FLAG

#endif /* _CONFIG_H_ */

/* @(#) $Id$ */
