/*
 * Lachesis high-level IRC Interface API
 */

#ifndef _IRC_H_
#define _IRC_H_

#ifdef __cplusplus
#include "irccl.h"

#define UHFLAG_OPER 1
#define UHFLAG_AWAY 2

void HLIRC_AddChan(const char *);
void HLIRC_RemChan(const char *);
TF   HLIRC_CheckChan(const char *);
void HLIRC_CleanChan();
void HLIRC_BeginIRCInterface();
void HLIRC_EndIRCInterface();
void HLIRC_Cleanup();
#else

// Functions we provide to the direct interface to contact us

void ConnectionReady();

void HandleDCCChatRequest(void *, const char *nick);
void HandleDCCChatRequestPfx(void *, const char *prefix);
void HandleDCCChatOpened(void *);
void HandleDCCChatClosed(void *);
void HandleDCCChatMessage(void *, const char *);
void HandleNumeric(const int, const char *);
void HandleNotice(const char *prefix, const char *target, const char *);
const char * HandleCTCP(const char *prefix, const char *target, const char *);
void HandleCTCPReply(const char *prefix, const char *);
void HandleNames(const char *channel, const char **, const int);
void HandleName(const char *channel, const char *);
void HandleInvite(const char *prefix, const char *);
void HandleKick(const char *nick, const char *target, const char *channel, const char *);
void HandleMSG(const char *prefix, const char *);
void HandlePublic(const char *prefix, const char *target, const char *);
void HandleJoined(const char *channel);
void HandleJoin(const char *prefix, const char *channel);
void HandleOurNickChanged(const char *nick);
void HandleNickChange(const char *prefix, const char *nick);
void HandlePart(const char *nick, const char *channel, const char *);
void HandleQuit(const char *nick, const char *);
void HandleDisconnect(const char *);
void HandleUserhost(const char *nick, const char *user, const char *host);

#endif /* __cplusplus */

#endif /* _IRC_H_ */
