/*
 * Lachesis, an IRCRPG combat engine - Bot action command handler.
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 * Note: This acts as the root command handler for RPGServ.
 */

#include <string.h>
#include <stdio.h>
#include "root.h"
#include "actions.h"
#ifdef RPGSERV
#include "authcmd.h"
#include "chancmd.h"
#endif
#include "../ircint.h"
#include "../lachesis.h"
#include "../utils.h"
#include "../auth.h"

extern char *irc_curchan;

#ifndef RPGSERV
extern Cmd_PMod cmd_modules;

void Cmd_actions_Init()
{
  Cmd_Alloc(&Cmd_Actions_Root, "do", CMD_AUTH_MASTER);
}
#else
void Cmd_Init()
{
}

void Cmd_Cleanup()
{
}
#endif

#ifdef RPGSERV
void Cmd_Root(void *ticket, int auth, const char *str)
{
#else
void Cmd_Actions_Root(void *ticket, int auth, const char *str)
{
#endif
  const char *data, *cmd;
  data = str;

  if (str==NULL) {
    Auth_CmdResult(ticket, auth,
		   "Usage: do {say|action|nick|chan|quote|quit}");
    return ;
  }
  cmd = Util_Separate(&data, 32);
  if (cmd==NULL) {
    cmd = data;
    data = NULL;
  }
#ifdef RPGSERV
  if (strcasecmp(cmd, "AUTH")==0) {
    Cmd_Auth_Root(ticket, auth, data);
    return ;
  }
  if (auth<CMD_AUTH_USER) {
    Auth_CmdResult(ticket, auth, "You are not an authorized user.");
    return ;
  }
#endif
  if (strcasecmp(cmd, "SAY")==0) {
    if (irc_curchan&&*irc_curchan)
      IRC_Public(irc_curchan, data);
    else
      Auth_CmdResult(ticket, auth, "No current channel.");
    return ;
  }
  if (strcasecmp(cmd, "ACTION")==0 || strcasecmp(cmd, "EMOTE")==0 ||
      strcasecmp(cmd, "POSE")==0 || strcasecmp(cmd, "ME")==0) {
    if (irc_curchan&&*irc_curchan)
      IRC_Action(irc_curchan, data);
    else
      Auth_CmdResult(ticket, auth, "No current channel.");
    return ;
  }
  if (strcasecmp(cmd, "NICK")==0) {
    cmd = Util_Separate(&data, 32);
    if (cmd==NULL)
      IRC_Nick(data);
    else
      IRC_Nick(cmd);
    return ;
  }
#ifdef RPGSERV
  if (strcasecmp(cmd, "CHAN")==0) {
    Cmd_Chan_Root(ticket, auth, data);
    return ;
  }
#endif
  if (strcasecmp(cmd, "QUOTE")==0) {
#ifdef RPGSERV
    if (auth<CMD_AUTH_MASTER) {
      Auth_CmdResult(ticket, auth, "Access to this command is restricted.");
      return ;
    }
#endif
    if (data == NULL) {
      Auth_CmdResult(ticket, auth, "No command provided to send!");
      return ;
    }
    IRC_Quote(data, FALSE);
    return ;
  }
  if (strcasecmp(cmd, "QUIT")==0 || strcasecmp(cmd, "DIE")==0 ||
      strcasecmp(cmd, "EXIT")==0 || strcasecmp(cmd, "SIGNOFF")==0) {
#ifdef RPGSERV
    if (auth<CMD_AUTH_MASTER) {
      Auth_CmdResult(ticket, auth, "Access to this command is restricted.");
      return ;
    }
#endif
    if (data!=NULL)
      IRC_Quit(data);
    else
      IRC_Quit("Lachesis shutting down.");
    Shutdown();
  }
  Auth_CmdResult(ticket, auth,
#ifdef RPGSERV
		 Util_FormatD("I do not recognize %s as a command.", cmd,
			      NULL, NULL)
#else
		 Util_FormatD("The do command tree does not contain %s.", cmd,
			      NULL, NULL)
#endif
		 );
}
