/* Bot Net Example file
  (c) Christophe CALMEJANE - 1999'01
  aka Ze KiLleR / SkyTech

  Adapted for Lachesis interface by M. Dennis - 2002
*/


#include "../botnet/makelib/botnet.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <errno.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <sys/stat.h>
#include "../utsep.c"

void DoQuote(BN_PInfo I, const char *str)
{
  char cmd[21];
  const char *data = str;
  Util_SepTo(cmd, 21, &data, 32);
  BN_SendMessage(I, BN_MakeMessage(NULL, cmd, data), BN_LOW_PRIORITY);
}

void DoPQuote(BN_PInfo I, const char *str)
{
  char cmd[21];
  const char *data = str;
  Util_SepTo(cmd, 21, &data, 32);
  BN_SendMessage(I, BN_MakeMessage(NULL, cmd, data), BN_HIGH_PRIORITY);
}

void DoNick(BN_PInfo I, const char *str)
{
  BN_SendNickMessage(I, str);
}

void DoPublic(BN_PInfo I, const char *str)
{
  char chan[51];
  const char *data = str;
  Util_SepTo(chan, 51, &data, 32);
  BN_SendChannelMessage(I, chan, data);
}

void DoAction(BN_PInfo I, const char *str)
{
  char chan[51];
  const char *data = str;
  Util_SepTo(chan, 51, &data, 32);
  BN_SendActionMessage(I, chan, data);
}

void DoMSG(BN_PInfo I, const char *str)
{
  char target[51]; // Just in case...
  const char *data = str;
  Util_SepTo(target, 51, &data, 32);
  BN_SendPrivateMessage(I, target, data);
}

void DoWallop(BN_PInfo I, const char *str)
{
  BN_SendWallopMessage(I, str);
}

void DoJoin(BN_PInfo I, const char *str)
{
  char chan[51];
  const char *data = str;
  Util_SepTo(chan, 51, &data, 32);
  BN_SendJoinMessage(I, chan, data);
}

void DoQuit(BN_PInfo I, const char *str)
{
  BN_SendQuitMessage(I, str);
  exit (0);
}

void DoRegister(BN_PInfo I, const char *str)
{
  char nick[31], user[21];
  const char *data = str;
  Util_SepTo(nick, 31, &data, 32);
  Util_SepTo(user, 21, &data, 32);
  BN_Register(I, nick, user, data);
}

void ProcOnConnected(BN_PInfo I,const char HostName[])
{
  struct sockaddr_in sin;
  socklen_t slen;
  BN_EnableFloodProtection(I,100,1000,60);
  slen=sizeof(struct sockaddr_in);
  getsockname(I->Socket, (struct sockaddr *)&sin, &slen);
  printf("CONNECT %lu %s\n",ntohl(sin.sin_addr.s_addr),HostName);
}

void ProcOnStatus(BN_PInfo I,const char Msg[],int Code)
{
  printf("NUMERIC %d %s\n",Code,Msg);
}

void ProcOnRegistered(BN_PInfo I)
{
  printf("REGISTERED\n");
}

void ProcOnUnknown(BN_PInfo I,const char Who[],const char Command[],const char Msg[])
{
  printf("UNKNOWN %s %s %s\n",Who,Command,Msg);
}

void ProcOnError(BN_PInfo I,int err)
{
  printf("ERROR %s\n", strerror(err));
}

void ProcOnDisconnected(BN_PInfo I,const char Msg[])
{
  printf("DISCONNECT %s\n",Msg);
  exit (0);
}

void ProcOnNotice(BN_PInfo I,const char Who[],const char Whom[],const char Msg[])
{
  printf("NOTICE %s %s %s\n",Who,Whom,Msg);
}

char *ProcOnCTCP(BN_PInfo I,const char Who[],const char Whom[],const char Type[])
{
  char *temp, *ptr;
  temp = strdup(Type);
  ptr = strchr(temp, 0)-1;
  if (*ptr==1)
    *ptr = 0;
  if (temp[0]==1)
    ptr = temp+1;
  else
    ptr = temp;
  printf("CTCP %s %s %s\n",Who,Whom,ptr);
  free (temp);
  return NULL;
}

void ProcOnCTCPReply(BN_PInfo I,const char Who[],const char Whom[],const char Msg[])
{
  char *temp, *ptr;
  temp = strdup(Msg);
  ptr = strchr(temp, 0)-1;
  if (*ptr==1)
    *ptr = 0;
  if (temp[0]==1)
    ptr = temp+1;
  else
    ptr = temp;
  printf("CTCPREPLY %s %s %s\n",Who,Whom,ptr);
  free (temp);
}

void ProcOnNames(BN_PInfo I,const char Channel[],const char *Names[],int Count)
{
  int i;
  for(i=0;i<Count;i++)
    printf("NAME %s %s\n",Channel,Names[i]);
}

void ProcOnInvite(BN_PInfo I,const char Chan[],const char Who[],const char Whom[])
{
  printf("INVITE %s %s %s\n",Who,Chan);
}

void ProcOnKick(BN_PInfo I,const char Chan[],const char Who[],const char Whom[],const char Msg[])
{
  printf("KICK %s %s %s %s\n",Who,Whom,Chan,Msg);
}

void ProcOnPrivateTalk(BN_PInfo I,const char Who[],const char Whom[],const char Msg[])
{
  // Hoping this is correct...
  printf("MSG %s %s\n",Who,Msg);
}

void ProcOnAction(BN_PInfo I,const char Chan[],const char Who[],const char Msg[])
{
  printf("ACTION %s %s %s\n",Who,Chan,Msg);
}

void ProcOnChannelTalk(BN_PInfo I,const char Chan[],const char Who[],const char Msg[])
{
  printf("PUBLIC %s %s %s\n",Who,Chan,Msg);
}

void ProcOnJoinChannel(BN_PInfo I,const char Chan[])
{
  printf("JOINED %s\n",Chan);
}

void ProcOnJoin(BN_PInfo I,const char Chan[],const char Who[])
{
  printf("JOIN %s %s\n",Who,Chan);
}

void ProcOnNick(BN_PInfo I,const char Who[],const char Msg[])
{
  printf("NICK %s %s\n",Who,Msg);
}

void ProcOnPart(BN_PInfo I,const char Chan[],const char Who[],const char Msg[])
{
  char nick[31];
  BN_ExtractNick(Who,nick,31);
  if (Msg==NULL)
    printf("PART %s %s\n",nick,Chan);
  else
    printf("PART %s %s %s\n",nick,Chan,Msg);
}

void ProcOnQuit(BN_PInfo I,const char Who[],const char Msg[])
{
  char nick[31];
  BN_ExtractNick(Who,nick,31);
  printf("QUIT %s %s\n",nick,Msg);
}

struct strtofunc_map {
  const char *str;
  void (*fun)(BN_PInfo,const char *);
};

const struct strtofunc_map EVENT_LIST[] = {
  { "QUOTE", &DoQuote },
  { "PQUOTE", &DoPQuote },
  { "NICK", &DoNick },
  { "PUBLIC", &DoPublic },
  { "ACTION", &DoAction },
  { "MSG", &DoMSG },
  { "WALLOP", &DoWallop },
  { "JOIN", &DoJoin },
  { "QUIT", &DoQuit },
  { "REGISTER", &DoRegister },
  { NULL, NULL }
};

int main(int argc,char *argv[])
{
  BN_TInfo Info;
  unsigned short int port, c;
  char *input = NULL;
  const char *cmd, *data;
  size_t len = 0;
#ifdef USE_DEBUG_ICS
  int sock;
  struct sockaddr_un *sunaddr;

  sock = socket(PF_LOCAL, SOCK_STREAM, 0);
  sunaddr = (struct sockaddr_un *)malloc(sizeof(short int)+strlen("/tmp/lachesis-debug")+1);
  sunaddr->sun_family = AF_LOCAL;
  strcpy(sunaddr->sun_path, "/tmp/lachesis-debug");
  connect(sock, (struct sockaddr *)sunaddr, SUN_LEN(sunaddr));
  dup2(sock, STDIN_FILENO);
  dup2(sock, STDOUT_FILENO);
#endif

  fflush(stdout);
  setvbuf(stdout, NULL, _IOLBF, 1024);

  if(argc < 3)
  {
    fputs("Missing args",stderr);
    return -1;
  }
  port = atoi(argv[2]);

  printf("DEBUG Connecting to %s %d\n", argv[1], port);
  printf("VERSION %s\n", BN_GetCopyright());
  //  fflush(stdout);

  memset(&Info,0,sizeof(Info));
  Info.CB.OnConnected = ProcOnConnected;
  Info.CB.OnRegistered = ProcOnRegistered;
  Info.CB.OnUnknown = ProcOnUnknown;
  Info.CB.OnDisconnected = ProcOnDisconnected;
  Info.CB.OnError = ProcOnError;
  Info.CB.OnNotice = ProcOnNotice;
  Info.CB.OnStatus = ProcOnStatus;
  Info.CB.OnCTCP = ProcOnCTCP;
  Info.CB.OnCTCPReply = ProcOnCTCPReply;
  Info.CB.OnNames = ProcOnNames;
  Info.CB.OnInvite = ProcOnInvite;
  Info.CB.OnKick = ProcOnKick;
  Info.CB.OnPrivateTalk = ProcOnPrivateTalk;
  Info.CB.OnAction = ProcOnAction;
  Info.CB.OnChannelTalk = ProcOnChannelTalk;
  Info.CB.OnJoinChannel = ProcOnJoinChannel;
  Info.CB.OnJoin = ProcOnJoin;
  Info.CB.OnNick = ProcOnNick;
  Info.CB.OnPart = ProcOnPart;
  Info.CB.OnQuit = ProcOnQuit;

  while(BN_Connect(&Info,argv[1],port,PROCESS_NEW_THREAD)!=true)
  {
    sleep(10);
  }

  while (1) {
    char cmd[21];
    const char *data;

    //    fflush(stdout);
    getline(&input, &len, stdin);
    (*strchr(input, '\n'))=0;
    data = (const char *)input;
    Util_SepTo(cmd, 21, &data, 32);
    for (c=0;EVENT_LIST[c].str!=NULL;c++)
      if (strcasecmp(cmd, EVENT_LIST[c].str)==0) {
	(*(EVENT_LIST[c].fun))(&Info, data);
	break;
      }
  }
}

