/*
 * Lachesis IRCRPG Combat engine - Logging system
 * Copyright 2003-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _LOG_H_
#define _LOG_H_

#include "auth.h"
#include "types.h"

void Log_Init();
void Log_Cleanup();
void Log_CommitComment(const char *);
void Log_CommitDescription(const char *);
void Log_CommitLine(const char *);
void Log_FormatLine(char *, size_t, const char *, TF);
int Log_ParseType(char *);
void Log_Public(Auth_PUser, const char *, const char *);
void Log_Action(const char *, const char *);

#endif

/* @(#) $Id: log.h,v 1.1.1.1 2004/01/16 07:28:15 lachesis Exp $ */
