/*
 * Lachesis, an IRCRPG combat engine - Root command handler.
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CMD_ROOT_H_
#define _CMD_ROOT_H_

#include "../lachesis.h"

#define ALLOC_CMD       11

#define CMD_AUTH_NONE   0
#define CMD_AUTH_USER   1
#define CMD_AUTH_MASTER 2

#ifndef RPGSERV
typedef struct tag_cmd_mod {
  void (*f)(void *, int, const char *);
  char cmd[ALLOC_CMD];
  int auth;
  struct tag_cmd_mod *next;
#ifdef __cplusplus
  tag_cmd_mod() { f = NULL;  auth = CMD_AUTH_USER; }
#endif
} Cmd_TMod, *Cmd_PMod;

void Cmd_Alloc(void (*f)(void *, int, const char *), const char *, int);
#endif
void Cmd_Init();
void Cmd_Cleanup();
void Cmd_Root(void *, int, const char *);

#endif

/* @(#) $Id: root.h,v 1.1.1.1 2004/01/16 07:28:15 lachesis Exp $ */
