/*
 * Lachesis, an IRCRPG combat engine - Random number generation
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 *
 * Since the random elements of the formulas are stated as dice rolls,
 * the random number generation will operate on that basis.
 */

#include <string.h>
//#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "random.h"
#include "../utils.h"
#include "../config.h"

TF Random_Roll(unsigned long count, unsigned long magnitude, long floor,
	       long **rolls)
{
  unsigned long excess, loop;

  if (rolls==NULL)
    return FALSE;
  if (count==0||count>DICE_MAX)
    return FALSE;
  if (magnitude<2)
    return FALSE;
  *rolls = new long[count+1];
  **rolls = 0;
  for (loop=0;loop<count;loop++) {
    excess = RAND_MAX / magnitude;
    if (excess==0) {
      delete [] *rolls;
      return FALSE;
    }
    do
      (*rolls)[loop+1] = rand() / excess;
    while ((*rolls)[loop+1]>=magnitude);
    if (floor<0) {
      unsigned long sub = (unsigned long)(-1*floor);
      if (sub>(*rolls)[loop+1])
	(*rolls)[loop+1] = sub - (*rolls)[loop+1];
      else
	(*rolls)[loop+1] -= sub;
    } else
      (*rolls)[loop+1] += (unsigned long)(floor);
    (*rolls)[0] += (*rolls)[loop+1];
  }
  return TRUE;
}

TF Random_WRoll(unsigned long count, unsigned long threshold, long **rolls)
{
  // This roller has been added for Storm, and meets the roll requirements
  // for Werewolf.
  unsigned long excess, loop;

  if (rolls==NULL)
    return FALSE;
  if (count==0||count>DICE_MAX)
    return FALSE;
  if (threshold<2||threshold>10)
    return FALSE;
  *rolls = new long[count+1];
  **rolls = 0;
  for (loop=0;loop<count;loop++) {
    excess = RAND_MAX / 10;
    do
      (*rolls)[loop+1] = rand() / excess + 1;
    while ((*rolls)[loop+1]>10);

    if ((*rolls)[loop+1]==1)
      (**rolls)--;
    else if ((*rolls)[loop+1]>=threshold)
      (**rolls)++;
  }
  return TRUE;
}
