/*
 * Authentication system for Lachesis
 */

#ifndef _AUTH_H_
#define _AUTH_H_

#include "types.h"
#include "irc.h"
#include "alloc.h"

class Auth_TUHCB;

// NOTE: Auth_TUser will be an AutoList-based class. All newly-constructed
// members will be added to the end of the list. To remove a member simply
// delete it; the destructor will handle the rest.
// 20021015, Karinu - So it was hoped... apparently only one dtor can
// access member data. AutoList is now obsolete. The behavior is being
// added directly to the classes that previously inherited it.
// ...or not. Same problem. For some reason some data members can be accessed
// and others cannot. Abandoning real dtors altogether *sigh*
class Auth_TUser {
  friend void Auth_VerifyAndSendMSG(Auth_TUHCB*);
  friend void Cmd_Auth_HandlePasswd(void *, int, const char *);
 private:
  char acct[ALLOC_ACCT];
  char pass[ALLOC_PASS];
  char nick[ALLOC_NICK];
  char user[ALLOC_USER];
  char host[ALLOC_HOST];
  IRC_PCL chans;
  TF dcc_active;
  void *dcc_cookie;
  static uint16 length;
  static Auth_TUser *master, *first, *last;
  Auth_TUser *next, *prev;
 public:
  TF security;
  TF usemsg;
#ifndef RPGSERV
  TF debug;
  TF sounds;
#endif
  Auth_TUser(const char *, const char *, TF);
  static void Delete(Auth_TUser *);
  static void FlushList();
  static Auth_TUser * GetUser(const char *);
  static Auth_TUser * GetMaster();
  static inline Auth_TUser * GetFirst() { return first; }
  static inline Auth_TUser * GetLast() { return last; }
  inline Auth_TUser * GetNext() { return next; }
  inline Auth_TUser * GetPrev() { return prev; }
  static inline uint16 GetLength() { return length; }
  const char * GetAcct() const;
  const char * GetNick() const;
  const char * GetUser() const;
  const char * GetHost() const;
  IRC_PCL GetChans();
  TF Login(const char *, const char *, const char *, const char *, IRC_PCL);
  void Logout();
  static Auth_TUser * MatchNick(const char *, TF flag = FALSE);
  static Auth_TUser * MatchUH(const char *, const char *);
  static Auth_TUser * MatchPrefix(const char *);
  static Auth_TUser * MatchDCCCookie(void *, TF flag = FALSE);
  void AddTracking(const char *);
  void RemTracking(const char *);
  void ChangeTracking(const char *);
  void StartTracking(const char *, const char *);
  void FlushTracking();
  static void FlushAllTracking();
  TF IsTracking(const char *) const;
  void * RegisterDCC(void *);
  void SetDCCStatus(TF);
  TF GetDCCStatus() const;
  void SendMessage(const char *);
};

typedef Auth_TUser *Auth_PUser;

class Auth_TTicket {
 private:
  IRC_PCL chans;
  char nick[ALLOC_NICK];
  char user[ALLOC_NICK];
  char host[ALLOC_HOST];
  static Auth_TTicket *first, *last, *stale;
  Auth_TTicket *next, *prev;
 public:
  Auth_TTicket(const char *, const char *, const char *, const char *, 
	       IRC_PCL chans = NULL);
  static void CleanStale();
  static void Delete(Auth_TTicket *);
  static void DeleteMe(Auth_TTicket *);
  static void FlushList();
  static Auth_TTicket * MatchNick(const char *);
  static inline Auth_TTicket * GetFirst() { return first; }
  static inline Auth_TTicket * GetLast() { return last; }
  inline Auth_TTicket * GetNext() { return next; }
  inline Auth_TTicket * GetPrev() { return prev; }
  const char * GetNick() const;
  const char * GetUser() const;
  const char * GetHost() const;
  IRC_PCL GetChans();
  void AddTracking(const char *);
  void RemTracking(const char *);
  void ChangeTracking(const char *);
  TF IsTracking(const char *) const;
  void FlushTracking();
  void SendMessage(const char *);
};

typedef Auth_TTicket *Auth_PTicket;

class Auth_TUHCB {
 private:
  void (*f)(Auth_TUHCB *);
  char nick[ALLOC_NICK];
  char user[ALLOC_USER];
  char host[ALLOC_HOST];
  static Auth_TUHCB *first, *last;
  Auth_TUHCB *next, *prev;
 public:
  void *data;
  Auth_TUHCB(void (*fun)(Auth_TUHCB *), const char *s_nick);
  static void Delete(Auth_TUHCB *);
  static void FlushList();
  static inline Auth_TUHCB * GetFirst() { return first; }
  inline Auth_TUHCB * GetNext() { return next; }
  inline Auth_TUHCB * GetPrev() { return prev; }
  inline const char * GetNick() const { return nick; }
  inline const char * GetUser() const { return user; }
  inline const char * GetHost() const { return host; }
  static void UHCR(const char *, const char *, const char *);
};

typedef Auth_TUHCB *Auth_PUHCB;

void Auth_Init();
void Auth_Connect();
void Auth_Disconnect(const char *);
TF Auth_Add(void **, const char *acct, const char *pass);
void Auth_Track(const char *nick, const char *channel, TF flag);
void Auth_TrackCR(Auth_PUHCB);
void Auth_TrackPr(const char *prefix, const char *channel);
void Auth_RemTrack(const char *channel);
void Auth_FlushTrack();
void Auth_Rem(void *ticket, uint8 auth);
void Auth_Userhost(const char *nick, const char *user, const char *host);
void Auth_Nick(const char *prefix, const char *nick);
void Auth_Cleanup();
void Auth_DCCRequest(const char *nick, void *cookie);
void Auth_DCCRequestCR(Auth_PUHCB);
void Auth_DCCRequestPfx(const char *prefix, void *cookie);
void Auth_DCCEstablished(void *cookie);
void Auth_DCCLost(void *cookie);
void Auth_CmdResult(void *, uint8, const char *);
void Auth_DCCMessage(void *cookie, const char *message);
void Auth_IRCMessage(const char *prefix, const char *message);
void Auth_NotifyMaster(const char *message);

#endif
