#include <unistd.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include "alloc.h"

ssize_t fdgetline(char **input, size_t *len, int fd)
{
  int c, r, l;

  if (*len==0) {
    *len = 32;
    *input = (char *)malloc(32);
  }
  l=32;
  for (c=0;1;c++) {
    if (c>=*len+1) {
      char *temp;
      if (l==32)
	while (l<=*len)
	  l*=2;
      else
	l*=2;
      temp = (char *)realloc(*input, l);
      if (temp == NULL) {
	fprintf(stderr, "Memory allocation error: %m\n");
	exit (255);
      }
      *input = temp;
      *len = l;
    }
    r = read(fd, *input+c, 1);
    if (r==-1) {
      if (errno!=EAGAIN) {
	fprintf(stderr, "fdinput: read: %m\n");
	return -1;
      } else {
	(*input)[c]='\n';
	(*input)[c+1]=0;
	fprintf(stderr, "fdinput: read would block! Input so far: %s", 
		*input);
	return c+1;
      }
    } else if (r==0)
      return 0;
    if ((*input)[c]=='\n') {
      (*input)[c+1] = 0;
      return c+1;
    }
  }
}

int fdputs(const char *S, int fd)
{
  // This function will perform blocking writes even for non-blocking
  // descriptors.
  fd_set writes;
  int c;
  ssize_t r;
  const char *tail;

  c = 0;
  tail = strchr(S, 0);
  while (S[c]) {
    FD_ZERO(&writes);
    FD_SET(fd, &writes);
    select(FD_SETSIZE, NULL, &writes, NULL, NULL);
    r = write(fd, S+c, tail-(S+c));
    if (r==-1) {
      if (errno!=EAGAIN)
	return EOF;
    } else
      c+=r;
  }
  return 0;
}

int fdprintf(int fd, const char *template, ...)
{
  va_list ap;
  int r;
  char *buffer;
  va_start(ap, template);
  r = vasprintf(&buffer, template, ap);
  va_end(ap);
  if (r<0)
    return r;
  if (fdputs(buffer, fd)<0)
    r = -1;
  free (buffer);
  return r;
}
